
function [error] = optimiseFun_Classic(parms, medSWA, N, A)

% Upack parms
a = parms(1);
b = parms(2);
S0 = parms(3);
Smax = parms(4);
Smin = parms(5);

% S model
Tmax = 43200;
S = zeros(1,Tmax);
S(1) = S0;
for t=2:Tmax    
	if N(t)==0
    	dSdt = a*(Smax - S(t-1)); 
    else 
    	dSdt = b*(Smin - S(t-1));
    end
    S(t) = S(t-1) + dSdt;
end

% Error
[medProcS, durN] = medianBoutNREM(S, N, A);
durN(durN<=15) =[];
w = durN/sum(durN);
error = sum(abs(medSWA(:,2) - medProcS(:,2)) .*w');

end 
